// Zoo class for generating random animal and list of animals
// Written by Craig Miller
// October 2022
//   Version 2 (updated 6 Oct 2022) --- adds additional methods for producing animal records
//   Version 3 (updated October 2024) --- new method for adding an animal; flies property for the supply
//
// Example use:
//   myZoo = new Zoo();
//
//   myZoo.getRandomAnimal() --> returns animal (string) randomly chosen
//   myZoo.getRandomZoo(size) --> returns array of animal strings 
//         (length specified by size), randomly selected
//   myZoo.getRandomRecord() --> returns an animal record (with name, type and flies properties), randomly chosen
//   myZoo.getRandomRecList(size) --> returns array of a animal records
//         (length specified by size), randomly selected
//   myZoo.add(animalRecord) --> adds an additional animal, defined as objectt with name, type and flies properties

class Zoo {
  constructor() {
    this.supply = [
      { name: 'emu', type: 'bird', flies: false }, 
      { name: 'robin', type: 'bird', flies: true }, 
      { name: 'bat', type: 'mammal', flies: true },  
      { name: 'cobra', type: 'reptile', flies: false }, 
      { name: 'ape', type: 'mammal', flies: false },
      { name: 'zebra', type: 'mammal', flies: false },
      { name: 'hippo', type: 'mammal', flies: false },
      { name: 'giraffe', type: 'mammal', flies: false }
    ];
  }

  getRandomAnimal() {
    let selectNum = Math.floor(Math.random() * this.supply.length);
    return this.supply[selectNum].name;
  }

  getRandomZoo(size) {
    let list = [];
    for (let i = 0; i < size; i++) {
      list.push(this.getRandomAnimal());
    }
    return list;
  }

  getRandomRecord() {
    let selectNum = Math.floor(Math.random() * this.supply.length);
    return this.supply[selectNum];
  }

  getRandomRecList(size) {
    let list = [];
    for (let i = 0; i < size; i++) {
      list.push(this.getRandomRecord());
    }
    return list;
  }

  add(animal_record) {
    this.supply.push(animal_record);
  }

}
