// Spinner class simulating a spinner that randomly produces a color from a specific set
// Written by Craig Miller
// September 2024
// Updated October 10, 2025 to fix getMostFrequent

//
// Example use:
//   spinner = new Spinner(['red', 'blue', 'green']);
//
//   spinner.spin() --> simulates spin and returns randomly selected color
//   spinner.numSpins() --> number of spins since the object was created
//   spinner.getMostFrequent() --> returns color with the most selections, with ties going to the first in specific set
//   spinner.history --> an array of spun colors


class Spinner {
  constructor(color_list) {
    this.colors = color_list;
    this.history = [];
    this.color_counts = {};
    for (let c of color_list) {
        this.color_counts[c] = 0;
    }
  }

  numSpins() {
    return this.history.length;
  }

  getMostFrequent() {
    let max = 0;
    let most = '';
    for (let c of this.colors) {
        if (this.color_counts[c] > max) {
            most = c;
            max = this.color_counts[c];
        }
    }
    return most;
  }

  spin() {
    const index = Math.floor((Math.random() * this.colors.length));
    const chosen_color = this.colors[index];
    this.history.push(chosen_color);
    this.color_counts[chosen_color] += 1;
    return chosen_color;
  }
}
