// Use with demo.html
// Updated October 2023, October 2025 (V3)


window.addEventListener('load', function() {

    const key_word_box = document.getElementById("key-word");
    const submit_button = document.getElementById("start");
    const result_area = document.getElementById('result');
    const names_area = document.getElementById('names');

    // This function is called when the response has returned
    const postResult = function(list)
    {
        if (list.length > 0) {
            result_area.innerHTML = 
                list[0].name + "<br />" + list[0].salary;
        }

        let nameList = "";
        for (let person of list) {
            nameList = nameList + person.name + "<br>";
        }
    
        names_area.innerHTML = nameList;
    }
    
    submit_button.addEventListener('click', function() {
        const searchWord = key_word_box.value;
        const query = new ChiEmpQuery(searchWord);
        query.retrieve(postResult);
        result_area.innerHTML = "waiting...";
    });
});

