// Tip calculator logic - no frameworks
(function(){
  const amountInput = document.getElementById('amount');
  const serviceSelect = document.getElementById('service');
  const calculateBtn = document.getElementById('calculateBtn');
  const tipAmountEl = document.getElementById('tipAmount');
  const totalAmountEl = document.getElementById('totalAmount');

  function formatUSD(value){
    return value.toLocaleString('en-US',{style:'currency',currency:'USD'});
  }

  function compute(){
    const raw = amountInput.value;
    const amount = parseFloat(raw);
    if (Number.isNaN(amount) || amount < 0){
      tipAmountEl.textContent = '—';
      totalAmountEl.textContent = '—';
      alert('Please enter a valid non-negative check amount.');
      return;
    }
    const rate = parseFloat(serviceSelect.value);
    const tip = Math.round((amount * rate + Number.EPSILON) * 100) / 100;
    const total = Math.round((amount + tip + Number.EPSILON) * 100) / 100;

    tipAmountEl.textContent = formatUSD(tip);
    totalAmountEl.textContent = formatUSD(total);
  }

  calculateBtn.addEventListener('click', compute);

  // allow Enter to trigger calculation when focus is on amount input
  amountInput.addEventListener('keydown', function(e){
    if (e.key === 'Enter') compute();
  });
})();
